// Study of Outdoor Propagation – Okumura Model
// OS: Windows 10
// Scilab Version: 6.1.0
// Course Instructor: Dr. V. A. Sankar Ponnapalli
// Institute: ICFAI Foundation for Higher Education, Hyderabad

clc;
clear;
close;

disp("Enter distance between Tx–Rx in km (Valid range: 1–100 km):");
d = input("Distance (km): ");

disp("Enter base station antenna height in meters (Valid range: 30–1000 m):");
ht = input("Base Station Height (m): ");

disp("Enter mobile station antenna height in meters (Valid range: 1–10 m):");
hr = input("Mobile Station Height (m): ");

disp("Choose Environment:");
disp("1. Urban");
disp("2. Suburban");
disp("3. Rural");
choice = input("Enter your choice (1–3): ");

select choice
    case 1 then
        environment = "urban";
    case 2 then
        environment = "suburban";
    case 3 then
        environment = "rural";
    else
        disp("Invalid choice. Defaulting to urban.");
        environment = "urban";
end

f_start = 150;    // MHz
f_end = 1920;     // MHz
f_step = 50;      // MHz
frequencies = f_start:f_step:f_end;

medianLoss = zeros(frequencies);

// ------------------ Path Loss Calculation -------------------
for i = 1:length(frequencies)
    f = frequencies(i);
    
    // Free space path loss
    Lf = 32.4 + 20*log10(f) + 20*log10(d);
    
    // Antenna gains
    Gt = 20*log10(ht / 200);
    Gr = 10*log10(hr / 3);
    
    // Median path loss
    Am = Lf - Gt - Gr;
    
    // Apply environment correction
    select environment
        case "suburban" then
            Am = Am - (2 * (log10(f / 28))^2) - 5.4;
        case "rural" then
            Am = Am - (4.78 * (log10(f))^2) + (18.33 * log10(f)) - 40.94;
    end
    
    medianLoss(i) = Am;
end

scf(0);
plot(frequencies, medianLoss, 'r-');
xlabel("Frequency (MHz)");
ylabel("Median Path Loss (dB)");
title("Okumura Model: Frequency vs Median Path Loss");
xgrid();

// Description of the Figure
// User Inputs:
//"Enter distance between Tx–Rx in km (Valid range: 1–100 km):"
//Distance (km): 100
//"Enter base station antenna height in meters (Valid range: 30–1000 m):"
//Base Station Height (m): 200
//"Enter mobile station antenna height in meters (Valid range: 1–10 m):"
//Mobile Station Height (m): 3
//"Choose Environment:"
//"1. Urban"
//"2. Suburban"
//"3. Rural"
//Enter your choice (1–3): 1
//The figure titled "Okumura Model: Frequency vs Median Path Loss" illustrates how path loss behaves with varying frequencies in an urban setting and how the system parameters (distance, a//ntenna heights, and frequency) influence the signal strength.
